# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 3
# Experiment: PMxPM, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR3_strategy.txt
# LLM Suggested Fallback: Not Provided

def sweet_venom(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:
        return "C"
    
    current_round = len(my_history) + 1  # 1-based index
    last_opp_move = opp_history[-1] if opp_history else "C"
    
    # Early rounds (1-3)
    if current_round <= 3:
        if "D" in opp_history:
            return last_opp_move
        else:
            return "C"
    
    # Middle rounds (4-7)
    elif current_round <= 7:
        if "D" not in opp_history:
            return "D" if random.random() < 0.1 else "C"
        else:
            if last_opp_move == "D":
                return "C" if random.random() < 0.2 else "D"
            else:
                return "C"
    
    # Late rounds (8-9)
    elif current_round <= 9:
        if opp_history.count("D") >= 2:
            return "D"
        else:
            if current_round == 9 and "D" in opp_history[-3:]:
                return "D"
            else:
                return "C"
    
    # Final round (10)
    else:
        return "D"